%------------------------------------------------------------------------------
% File     : ITP144^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer PHoareTotal problem prob_493__3263728_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : PHoareTotal/prob_493__3263728_1 [Des21]

% Status   : Theorem
% Rating   : 0.00 v7.5.0
% Syntax   : Number of formulae    :  315 ( 117 unt;  45 typ;   0 def)
%            Number of atoms       :  617 ( 354 equ;   0 cnn)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives : 3330 (  68   ~;   6   |;  57   &;2948   @)
%                                         (   0 <=>; 251  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   20 (   8 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  409 ( 409   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   46 (  43 usr;   2 con; 0-9 aty)
%            Number of variables   : 1203 ( 121   ^; 990   !;  30   ?;1203   :)
%                                         (  62  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:19:11.981
%------------------------------------------------------------------------------
% Could-be-implicit typings (4)
thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_tf_b,type,
    b: $tType ).

thf(ty_tf_a,type,
    a: $tType ).

% Explicit typings (41)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oab__group__add,type,
    ab_group_add: 
      !>[A: $tType] : $o ).

thf(sy_c_BNF__Def_Opick__middlep,type,
    bNF_pick_middlep: 
      !>[B: $tType,A: $tType,C: $tType] : ( ( B > A > $o ) > ( A > C > $o ) > B > C > A ) ).

thf(sy_c_BNF__Greatest__Fixpoint_OfromCard,type,
    bNF_Gr932048252omCard: 
      !>[A: $tType,B: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ B @ B ) ) > B > A ) ).

thf(sy_c_BNF__Greatest__Fixpoint_Oimage2p,type,
    bNF_Greatest_image2p: 
      !>[C: $tType,A: $tType,D: $tType,B: $tType] : ( ( C > A ) > ( D > B ) > ( C > D > $o ) > A > B > $o ) ).

thf(sy_c_BNF__Greatest__Fixpoint_OtoCard,type,
    bNF_Greatest_toCard: 
      !>[A: $tType,B: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ B @ B ) ) > A > B ) ).

thf(sy_c_BNF__Greatest__Fixpoint_OtoCard__pred,type,
    bNF_Gr1978856366d_pred: 
      !>[A: $tType,B: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ B @ B ) ) > ( A > B ) > $o ) ).

thf(sy_c_BNF__Greatest__Fixpoint_Ouniv,type,
    bNF_Greatest_univ: 
      !>[B: $tType,A: $tType] : ( ( B > A ) > ( set @ B ) > A ) ).

thf(sy_c_Fun_Obij__betw,type,
    bij_betw: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( set @ A ) > ( set @ B ) > $o ) ).

thf(sy_c_Fun_Ofun__upd,type,
    fun_upd: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > A > B > A > B ) ).

thf(sy_c_Fun_Oinj__on,type,
    inj_on: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( set @ A ) > $o ) ).

thf(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Hilbert__Choice_OEps,type,
    hilbert_Eps: 
      !>[A: $tType] : ( ( A > $o ) > A ) ).

thf(sy_c_Hilbert__Choice_Obijection,type,
    hilbert_bijection: 
      !>[A: $tType] : ( ( A > A ) > $o ) ).

thf(sy_c_Hilbert__Choice_Oinv__into,type,
    hilbert_inv_into: 
      !>[A: $tType,B: $tType] : ( ( set @ A ) > ( A > B ) > B > A ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Lattices__Big_Oord__class_Oarg__max,type,
    lattices_ord_arg_max: 
      !>[B: $tType,A: $tType] : ( ( B > A ) > ( B > $o ) > B ) ).

thf(sy_c_Lattices__Big_Oord__class_Oarg__max__on,type,
    lattic1534546155max_on: 
      !>[B: $tType,A: $tType] : ( ( B > A ) > ( set @ B ) > B ) ).

thf(sy_c_Lattices__Big_Oord__class_Ois__arg__max,type,
    lattic2130478198rg_max: 
      !>[B: $tType,A: $tType] : ( ( B > A ) > ( B > $o ) > B > $o ) ).

thf(sy_c_Lifting_Orel__pred__comp,type,
    rel_pred_comp: 
      !>[A: $tType,B: $tType] : ( ( A > B > $o ) > ( B > $o ) > A > $o ) ).

thf(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

thf(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

thf(sy_c_Product__Type_Obool_Ocase__bool,type,
    product_case_bool: 
      !>[A: $tType] : ( A > A > $o > A ) ).

thf(sy_c_Quotient_OQuotient3,type,
    quotient3: 
      !>[A: $tType,B: $tType] : ( ( A > A > $o ) > ( A > B ) > ( B > A ) > $o ) ).

thf(sy_c_Quotient_Oquot__type,type,
    quot_type: 
      !>[A: $tType,B: $tType] : ( ( A > A > $o ) > ( ( set @ A ) > B ) > ( B > ( set @ A ) ) > $o ) ).

thf(sy_c_Quotient_Oquot__type_Oabs,type,
    quot_abs: 
      !>[A: $tType,B: $tType] : ( ( A > A > $o ) > ( ( set @ A ) > B ) > A > B ) ).

thf(sy_c_Quotient_Oquot__type_Orep,type,
    quot_rep: 
      !>[B: $tType,A: $tType] : ( ( B > ( set @ A ) ) > B > A ) ).

thf(sy_c_Relation_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( B > B > $o ) > ( A > B ) > A > A > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( set @ A ) > ( set @ B ) ) ).

thf(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Ois__empty,type,
    is_empty: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Ois__singleton,type,
    is_singleton: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Oremove,type,
    remove: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_P,type,
    p: a > $o ).

thf(sy_v_Q,type,
    q: a > b > $o ).

% Relevant facts (256)
thf(fact_0_some__equality,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( P @ A2 )
     => ( ! [X: A] :
            ( ( P @ X )
           => ( X = A2 ) )
       => ( ( hilbert_Eps @ A @ P )
          = A2 ) ) ) ).

% some_equality
thf(fact_1_some__eq__trivial,axiom,
    ! [A: $tType,X2: A] :
      ( ( hilbert_Eps @ A
        @ ^ [Y: A] : ( Y = X2 ) )
      = X2 ) ).

% some_eq_trivial
thf(fact_2_some__sym__eq__trivial,axiom,
    ! [A: $tType,X2: A] :
      ( ( hilbert_Eps @ A
        @ ( ^ [Y2: A,Z: A] : ( Y2 = Z )
          @ X2 ) )
      = X2 ) ).

% some_sym_eq_trivial
thf(fact_3_verit__sko__ex_H,axiom,
    ! [A: $tType,P: A > $o,A3: $o] :
      ( ( ( P @ ( hilbert_Eps @ A @ P ) )
        = A3 )
     => ( ( ? [X3: A] : ( P @ X3 ) )
        = A3 ) ) ).

% verit_sko_ex'
thf(fact_4_verit__sko__forall,axiom,
    ! [A: $tType] :
      ( ( ^ [P2: A > $o] :
          ! [X3: A] : ( P2 @ X3 ) )
      = ( ^ [P3: A > $o] :
            ( P3
            @ ( hilbert_Eps @ A
              @ ^ [X4: A] :
                  ~ ( P3 @ X4 ) ) ) ) ) ).

% verit_sko_forall
thf(fact_5_someI2,axiom,
    ! [A: $tType,P: A > $o,A2: A,Q: A > $o] :
      ( ( P @ A2 )
     => ( ! [X: A] :
            ( ( P @ X )
           => ( Q @ X ) )
       => ( Q @ ( hilbert_Eps @ A @ P ) ) ) ) ).

% someI2
thf(fact_6_verit__sko__forall_H,axiom,
    ! [A: $tType,P: A > $o,A3: $o] :
      ( ( ( P
          @ ( hilbert_Eps @ A
            @ ^ [X4: A] :
                ~ ( P @ X4 ) ) )
        = A3 )
     => ( ( ! [X3: A] : ( P @ X3 ) )
        = A3 ) ) ).

% verit_sko_forall'
thf(fact_7_verit__sko__forall_H_H,axiom,
    ! [A: $tType,B2: A,A3: A,P: A > $o] :
      ( ( B2 = A3 )
     => ( ( ( hilbert_Eps @ A @ P )
          = A3 )
        = ( ( hilbert_Eps @ A @ P )
          = B2 ) ) ) ).

% verit_sko_forall''
thf(fact_8_someI__ex,axiom,
    ! [A: $tType,P: A > $o] :
      ( ? [X_1: A] : ( P @ X_1 )
     => ( P @ ( hilbert_Eps @ A @ P ) ) ) ).

% someI_ex
thf(fact_9_someI2__ex,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ? [X_1: A] : ( P @ X_1 )
     => ( ! [X: A] :
            ( ( P @ X )
           => ( Q @ X ) )
       => ( Q @ ( hilbert_Eps @ A @ P ) ) ) ) ).

% someI2_ex
thf(fact_10_someI2__bex,axiom,
    ! [A: $tType,A3: set @ A,P: A > $o,Q: A > $o] :
      ( ? [X5: A] :
          ( ( member @ A @ X5 @ A3 )
          & ( P @ X5 ) )
     => ( ! [X: A] :
            ( ( ( member @ A @ X @ A3 )
              & ( P @ X ) )
           => ( Q @ X ) )
       => ( Q
          @ ( hilbert_Eps @ A
            @ ^ [X4: A] :
                ( ( member @ A @ X4 @ A3 )
                & ( P @ X4 ) ) ) ) ) ) ).

% someI2_bex
thf(fact_11_some__eq__ex,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( P @ ( hilbert_Eps @ A @ P ) )
      = ( ? [X3: A] : ( P @ X3 ) ) ) ).

% some_eq_ex
thf(fact_12_some__eq__imp,axiom,
    ! [A: $tType,P: A > $o,A2: A,B3: A] :
      ( ( ( hilbert_Eps @ A @ P )
        = A2 )
     => ( ( P @ B3 )
       => ( P @ A2 ) ) ) ).

% some_eq_imp
thf(fact_13_tfl__some,axiom,
    ! [A: $tType,P4: A > $o,X5: A] :
      ( ( P4 @ X5 )
     => ( P4 @ ( hilbert_Eps @ A @ P4 ) ) ) ).

% tfl_some
thf(fact_14_Eps__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X: A] :
          ( ( P @ X )
          = ( Q @ X ) )
     => ( ( hilbert_Eps @ A @ P )
        = ( hilbert_Eps @ A @ Q ) ) ) ).

% Eps_cong
thf(fact_15_someI,axiom,
    ! [A: $tType,P: A > $o,X2: A] :
      ( ( P @ X2 )
     => ( P @ ( hilbert_Eps @ A @ P ) ) ) ).

% someI
thf(fact_16_verit__sko__forall__indirect2,axiom,
    ! [A: $tType,X2: A,P: A > $o,P5: A > $o] :
      ( ( X2
        = ( hilbert_Eps @ A
          @ ^ [X4: A] :
              ~ ( P @ X4 ) ) )
     => ( ! [X: A] :
            ( ( P @ X )
            = ( P5 @ X ) )
       => ( ( ! [X3: A] : ( P5 @ X3 ) )
          = ( P @ X2 ) ) ) ) ).

% verit_sko_forall_indirect2
thf(fact_17_verit__sko__forall__indirect,axiom,
    ! [A: $tType,X2: A,P: A > $o] :
      ( ( X2
        = ( hilbert_Eps @ A
          @ ^ [X4: A] :
              ~ ( P @ X4 ) ) )
     => ( ( ! [X3: A] : ( P @ X3 ) )
        = ( P @ X2 ) ) ) ).

% verit_sko_forall_indirect
thf(fact_18_some1__equality,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ? [X5: A] :
          ( ( P @ X5 )
          & ! [Y3: A] :
              ( ( P @ Y3 )
             => ( Y3 = X5 ) ) )
     => ( ( P @ A2 )
       => ( ( hilbert_Eps @ A @ P )
          = A2 ) ) ) ).

% some1_equality
thf(fact_19_verit__sko__ex__indirect2,axiom,
    ! [A: $tType,X2: A,P: A > $o,P5: A > $o] :
      ( ( X2
        = ( hilbert_Eps @ A @ P ) )
     => ( ! [X: A] :
            ( ( P @ X )
            = ( P5 @ X ) )
       => ( ( ? [X3: A] : ( P5 @ X3 ) )
          = ( P @ X2 ) ) ) ) ).

% verit_sko_ex_indirect2
thf(fact_20_verit__sko__ex__indirect,axiom,
    ! [A: $tType,X2: A,P: A > $o] :
      ( ( X2
        = ( hilbert_Eps @ A @ P ) )
     => ( ( ? [X3: A] : ( P @ X3 ) )
        = ( P @ X2 ) ) ) ).

% verit_sko_ex_indirect
thf(fact_21_Nitpick_OEps__psimp,axiom,
    ! [A: $tType,P: A > $o,X2: A,Y4: A] :
      ( ( P @ X2 )
     => ( ~ ( P @ Y4 )
       => ( ( ( hilbert_Eps @ A @ P )
            = Y4 )
         => ( ( hilbert_Eps @ A @ P )
            = X2 ) ) ) ) ).

% Nitpick.Eps_psimp
thf(fact_22_univ__def,axiom,
    ! [A: $tType,B: $tType] :
      ( ( bNF_Greatest_univ @ B @ A )
      = ( ^ [F: B > A,X6: set @ B] :
            ( F
            @ ( hilbert_Eps @ B
              @ ^ [X4: B] : ( member @ B @ X4 @ X6 ) ) ) ) ) ).

% univ_def
thf(fact_23_pick__middlep__def,axiom,
    ! [C: $tType,A: $tType,B: $tType] :
      ( ( bNF_pick_middlep @ B @ A @ C )
      = ( ^ [P3: B > A > $o,Q2: A > C > $o,A4: B,C2: C] :
            ( hilbert_Eps @ A
            @ ^ [B4: A] :
                ( ( P3 @ A4 @ B4 )
                & ( Q2 @ B4 @ C2 ) ) ) ) ) ).

% pick_middlep_def
thf(fact_24_some__in__eq,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( member @ A
        @ ( hilbert_Eps @ A
          @ ^ [X4: A] : ( member @ A @ X4 @ A3 ) )
        @ A3 )
      = ( A3
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% some_in_eq
thf(fact_25_inv__into__def2,axiom,
    ! [B: $tType,A: $tType] :
      ( ( hilbert_inv_into @ A @ B )
      = ( ^ [A5: set @ A,F: A > B,X4: B] :
            ( hilbert_Eps @ A
            @ ^ [Y: A] :
                ( ( member @ A @ Y @ A5 )
                & ( ( F @ Y )
                  = X4 ) ) ) ) ) ).

% inv_into_def2
thf(fact_26_inv__into__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( hilbert_inv_into @ A @ B )
      = ( ^ [A5: set @ A,F: A > B,X4: B] :
            ( hilbert_Eps @ A
            @ ^ [Y: A] :
                ( ( member @ A @ Y @ A5 )
                & ( ( F @ Y )
                  = X4 ) ) ) ) ) ).

% inv_into_def
thf(fact_27_quot__type_Osome__collect,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: ( set @ A ) > B,Rep: B > ( set @ A ),R2: A] :
      ( ( quot_type @ A @ B @ R @ Abs @ Rep )
     => ( ( R @ R2 @ R2 )
       => ( ( R
            @ ( hilbert_Eps @ A
              @ ^ [X4: A] : ( member @ A @ X4 @ ( collect @ A @ ( R @ R2 ) ) ) ) )
          = ( R @ R2 ) ) ) ) ).

% quot_type.some_collect
thf(fact_28_fromCard__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bNF_Gr932048252omCard @ A @ B )
      = ( ^ [A5: set @ A,R3: set @ ( product_prod @ B @ B ),K: B] :
            ( hilbert_Eps @ A
            @ ^ [B4: A] :
                ( ( member @ A @ B4 @ A5 )
                & ( ( bNF_Greatest_toCard @ A @ B @ A5 @ R3 @ B4 )
                  = K ) ) ) ) ) ).

% fromCard_def
thf(fact_29_arg__max__def,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord @ A )
     => ( ( lattices_ord_arg_max @ B @ A )
        = ( ^ [F: B > A,P3: B > $o] : ( hilbert_Eps @ B @ ( lattic2130478198rg_max @ B @ A @ F @ P3 ) ) ) ) ) ).

% arg_max_def
thf(fact_30_case__bool__if,axiom,
    ! [A: $tType] :
      ( ( product_case_bool @ A )
      = ( ^ [X4: A,Y: A,P3: $o] : ( if @ A @ P3 @ X4 @ Y ) ) ) ).

% case_bool_if
thf(fact_31_exE__some,axiom,
    ! [A: $tType,P: A > $o,C3: A] :
      ( ? [X_1: A] : ( P @ X_1 )
     => ( ( C3
          = ( hilbert_Eps @ A @ P ) )
       => ( P @ C3 ) ) ) ).

% exE_some
thf(fact_32_quot__type_Orep__inverse,axiom,
    ! [A: $tType,B: $tType,R: A > A > $o,Abs: ( set @ A ) > B,Rep: B > ( set @ A ),X2: B] :
      ( ( quot_type @ A @ B @ R @ Abs @ Rep )
     => ( ( Abs @ ( Rep @ X2 ) )
        = X2 ) ) ).

% quot_type.rep_inverse
thf(fact_33_quot__type_Oabs__inverse,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: ( set @ A ) > B,Rep: B > ( set @ A ),C3: set @ A] :
      ( ( quot_type @ A @ B @ R @ Abs @ Rep )
     => ( ? [X5: A] :
            ( ( R @ X5 @ X5 )
            & ( C3
              = ( collect @ A @ ( R @ X5 ) ) ) )
       => ( ( Rep @ ( Abs @ C3 ) )
          = C3 ) ) ) ).

% quot_type.abs_inverse
thf(fact_34_quot__type_Orep__inject,axiom,
    ! [A: $tType,B: $tType,R: A > A > $o,Abs: ( set @ A ) > B,Rep: B > ( set @ A ),X2: B,Y4: B] :
      ( ( quot_type @ A @ B @ R @ Abs @ Rep )
     => ( ( ( Rep @ X2 )
          = ( Rep @ Y4 ) )
        = ( X2 = Y4 ) ) ) ).

% quot_type.rep_inject
thf(fact_35_quot__type_Orep__prop,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: ( set @ A ) > B,Rep: B > ( set @ A ),Y4: B] :
      ( ( quot_type @ A @ B @ R @ Abs @ Rep )
     => ? [X: A] :
          ( ( R @ X @ X )
          & ( ( Rep @ Y4 )
            = ( collect @ A @ ( R @ X ) ) ) ) ) ).

% quot_type.rep_prop
thf(fact_36_arg__max__on__def,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord @ A )
     => ( ( lattic1534546155max_on @ B @ A )
        = ( ^ [F: B > A,S: set @ B] :
              ( lattices_ord_arg_max @ B @ A @ F
              @ ^ [X4: B] : ( member @ B @ X4 @ S ) ) ) ) ) ).

% arg_max_on_def
thf(fact_37_empty__Collect__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( collect @ A @ P ) )
      = ( ! [X4: A] :
            ~ ( P @ X4 ) ) ) ).

% empty_Collect_eq
thf(fact_38_Collect__empty__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ! [X4: A] :
            ~ ( P @ X4 ) ) ) ).

% Collect_empty_eq
thf(fact_39_all__not__in__conv,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( ! [X4: A] :
            ~ ( member @ A @ X4 @ A3 ) )
      = ( A3
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% all_not_in_conv
thf(fact_40_empty__iff,axiom,
    ! [A: $tType,C3: A] :
      ~ ( member @ A @ C3 @ ( bot_bot @ ( set @ A ) ) ) ).

% empty_iff
thf(fact_41_bot__apply,axiom,
    ! [C: $tType,D: $tType] :
      ( ( bot @ C )
     => ( ( bot_bot @ ( D > C ) )
        = ( ^ [X4: D] : ( bot_bot @ C ) ) ) ) ).

% bot_apply
thf(fact_42_quot__type_Orep__def,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: ( set @ A ) > B,Rep: B > ( set @ A ),A2: B] :
      ( ( quot_type @ A @ B @ R @ Abs @ Rep )
     => ( ( quot_rep @ B @ A @ Rep @ A2 )
        = ( hilbert_Eps @ A
          @ ^ [X4: A] : ( member @ A @ X4 @ ( Rep @ A2 ) ) ) ) ) ).

% quot_type.rep_def
thf(fact_43_toCard__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bNF_Greatest_toCard @ A @ B )
      = ( ^ [A5: set @ A,R3: set @ ( product_prod @ B @ B )] : ( hilbert_Eps @ ( A > B ) @ ( bNF_Gr1978856366d_pred @ A @ B @ A5 @ R3 ) ) ) ) ).

% toCard_def
thf(fact_44_bool_Osplit__sel__asm,axiom,
    ! [A: $tType,P: A > $o,F1: A,F2: A,Bool: $o] :
      ( ( P @ ( product_case_bool @ A @ F1 @ F2 @ Bool ) )
      = ( ~ ( ( Bool
              & ~ ( P @ F1 ) )
            | ( ~ Bool
              & ~ ( P @ F2 ) ) ) ) ) ).

% bool.split_sel_asm
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( collect @ A
        @ ^ [X4: A] : ( member @ A @ X4 @ A3 ) )
      = A3 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X: A] :
          ( ( P @ X )
          = ( Q @ X ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F3: A > B,G: A > B] :
      ( ! [X: A] :
          ( ( F3 @ X )
          = ( G @ X ) )
     => ( F3 = G ) ) ).

% ext
thf(fact_49_bot__set__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A @ ( bot_bot @ ( A > $o ) ) ) ) ).

% bot_set_def
thf(fact_50_quot__type_Orep_Ocong,axiom,
    ! [A: $tType,B: $tType] :
      ( ( quot_rep @ B @ A )
      = ( quot_rep @ B @ A ) ) ).

% quot_type.rep.cong
thf(fact_51_bot__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bot @ B )
     => ( ( bot_bot @ ( A > B ) )
        = ( ^ [X4: A] : ( bot_bot @ B ) ) ) ) ).

% bot_fun_def
thf(fact_52_emptyE,axiom,
    ! [A: $tType,A2: A] :
      ~ ( member @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ).

% emptyE
thf(fact_53_equals0D,axiom,
    ! [A: $tType,A3: set @ A,A2: A] :
      ( ( A3
        = ( bot_bot @ ( set @ A ) ) )
     => ~ ( member @ A @ A2 @ A3 ) ) ).

% equals0D
thf(fact_54_equals0I,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ! [Y3: A] :
          ~ ( member @ A @ Y3 @ A3 )
     => ( A3
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% equals0I
thf(fact_55_ex__in__conv,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( ? [X4: A] : ( member @ A @ X4 @ A3 ) )
      = ( A3
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% ex_in_conv
thf(fact_56_empty__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A
        @ ^ [X4: A] : $false ) ) ).

% empty_def
thf(fact_57_old_Obool_Osimps_I4_J,axiom,
    ! [A: $tType,F1: A,F2: A] :
      ( ( product_case_bool @ A @ F1 @ F2 @ $false )
      = F2 ) ).

% old.bool.simps(4)
thf(fact_58_old_Obool_Osimps_I3_J,axiom,
    ! [A: $tType,F1: A,F2: A] :
      ( ( product_case_bool @ A @ F1 @ F2 @ $true )
      = F1 ) ).

% old.bool.simps(3)
thf(fact_59_bool_Osplit__sel,axiom,
    ! [A: $tType,P: A > $o,F1: A,F2: A,Bool: $o] :
      ( ( P @ ( product_case_bool @ A @ F1 @ F2 @ Bool ) )
      = ( ( Bool
         => ( P @ F1 ) )
        & ( ~ Bool
         => ( P @ F2 ) ) ) ) ).

% bool.split_sel
thf(fact_60_bool_Ocase__eq__if,axiom,
    ! [A: $tType] :
      ( ( product_case_bool @ A )
      = ( ^ [F12: A,F22: A,Bool2: $o] : ( if @ A @ Bool2 @ F12 @ F22 ) ) ) ).

% bool.case_eq_if
thf(fact_61_bool_Ocase__distrib,axiom,
    ! [A: $tType,B: $tType,H: A > B,F1: A,F2: A,Bool: $o] :
      ( ( H @ ( product_case_bool @ A @ F1 @ F2 @ Bool ) )
      = ( product_case_bool @ B @ ( H @ F1 ) @ ( H @ F2 ) @ Bool ) ) ).

% bool.case_distrib
thf(fact_62_Set_Ois__empty__def,axiom,
    ! [A: $tType] :
      ( ( is_empty @ A )
      = ( ^ [A5: set @ A] :
            ( A5
            = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Set.is_empty_def
thf(fact_63_quot__type_Oabs__def,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: ( set @ A ) > B,Rep: B > ( set @ A ),X2: A] :
      ( ( quot_type @ A @ B @ R @ Abs @ Rep )
     => ( ( quot_abs @ A @ B @ R @ Abs @ X2 )
        = ( Abs @ ( collect @ A @ ( R @ X2 ) ) ) ) ) ).

% quot_type.abs_def
thf(fact_64_image2p__def,axiom,
    ! [D: $tType,B: $tType,A: $tType,C: $tType] :
      ( ( bNF_Greatest_image2p @ C @ A @ D @ B )
      = ( ^ [F: C > A,G2: D > B,R4: C > D > $o,X4: A,Y: B] :
          ? [X7: C,Y5: D] :
            ( ( R4 @ X7 @ Y5 )
            & ( ( F @ X7 )
              = X4 )
            & ( ( G2 @ Y5 )
              = Y ) ) ) ) ).

% image2p_def
thf(fact_65_Collect__empty__eq__bot,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( P
        = ( bot_bot @ ( A > $o ) ) ) ) ).

% Collect_empty_eq_bot
thf(fact_66_bot__empty__eq,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( A > $o ) )
      = ( ^ [X4: A] : ( member @ A @ X4 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% bot_empty_eq
thf(fact_67_inv__def,axiom,
    ! [B: $tType,A: $tType,F3: B > A] :
      ( ( hilbert_inv_into @ B @ A @ ( top_top @ ( set @ B ) ) @ F3 )
      = ( ^ [Y: A] :
            ( hilbert_Eps @ B
            @ ^ [X4: B] :
                ( ( F3 @ X4 )
                = Y ) ) ) ) ).

% inv_def
thf(fact_68_rel__pred__comp__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( rel_pred_comp @ A @ B )
      = ( ^ [R4: A > B > $o,P3: B > $o,X4: A] :
          ? [Y: B] :
            ( ( R4 @ X4 @ Y )
            & ( P3 @ Y ) ) ) ) ).

% rel_pred_comp_def
thf(fact_69_is__singletonI_H,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( A3
       != ( bot_bot @ ( set @ A ) ) )
     => ( ! [X: A,Y3: A] :
            ( ( member @ A @ X @ A3 )
           => ( ( member @ A @ Y3 @ A3 )
             => ( X = Y3 ) ) )
       => ( is_singleton @ A @ A3 ) ) ) ).

% is_singletonI'
thf(fact_70_top__apply,axiom,
    ! [C: $tType,D: $tType] :
      ( ( top @ C )
     => ( ( top_top @ ( D > C ) )
        = ( ^ [X4: D] : ( top_top @ C ) ) ) ) ).

% top_apply
thf(fact_71_UNIV__I,axiom,
    ! [A: $tType,X2: A] : ( member @ A @ X2 @ ( top_top @ ( set @ A ) ) ) ).

% UNIV_I
thf(fact_72_Collect__const,axiom,
    ! [A: $tType,P: $o] :
      ( ( P
       => ( ( collect @ A
            @ ^ [S2: A] : P )
          = ( top_top @ ( set @ A ) ) ) )
      & ( ~ P
       => ( ( collect @ A
            @ ^ [S2: A] : P )
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Collect_const
thf(fact_73_inv__identity,axiom,
    ! [A: $tType] :
      ( ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) )
        @ ^ [A4: A] : A4 )
      = ( ^ [A4: A] : A4 ) ) ).

% inv_identity
thf(fact_74_UNIV__def,axiom,
    ! [A: $tType] :
      ( ( top_top @ ( set @ A ) )
      = ( collect @ A
        @ ^ [X4: A] : $true ) ) ).

% UNIV_def
thf(fact_75_UNIV__eq__I,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ! [X: A] : ( member @ A @ X @ A3 )
     => ( ( top_top @ ( set @ A ) )
        = A3 ) ) ).

% UNIV_eq_I
thf(fact_76_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X: A] : ( member @ A @ X @ ( top_top @ ( set @ A ) ) ) ).

% UNIV_witness
thf(fact_77_image2pE,axiom,
    ! [D: $tType,B: $tType,A: $tType,C: $tType,F3: A > B,G: C > D,R: A > C > $o,Fx: B,Gy: D] :
      ( ( bNF_Greatest_image2p @ A @ B @ C @ D @ F3 @ G @ R @ Fx @ Gy )
     => ~ ! [X: A] :
            ( ( Fx
              = ( F3 @ X ) )
           => ! [Y3: C] :
                ( ( Gy
                  = ( G @ Y3 ) )
               => ~ ( R @ X @ Y3 ) ) ) ) ).

% image2pE
thf(fact_78_image2pI,axiom,
    ! [A: $tType,C: $tType,D: $tType,B: $tType,R: A > B > $o,X2: A,Y4: B,F3: A > C,G: B > D] :
      ( ( R @ X2 @ Y4 )
     => ( bNF_Greatest_image2p @ A @ C @ B @ D @ F3 @ G @ R @ ( F3 @ X2 ) @ ( G @ Y4 ) ) ) ).

% image2pI
thf(fact_79_quot__type_Oabs_Ocong,axiom,
    ! [B: $tType,A: $tType] :
      ( ( quot_abs @ A @ B )
      = ( quot_abs @ A @ B ) ) ).

% quot_type.abs.cong
thf(fact_80_empty__not__UNIV,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
     != ( top_top @ ( set @ A ) ) ) ).

% empty_not_UNIV
thf(fact_81_inv__equality,axiom,
    ! [A: $tType,B: $tType,G: B > A,F3: A > B] :
      ( ! [X: A] :
          ( ( G @ ( F3 @ X ) )
          = X )
     => ( ! [Y3: B] :
            ( ( F3 @ ( G @ Y3 ) )
            = Y3 )
       => ( ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ F3 )
          = G ) ) ) ).

% inv_equality
thf(fact_82_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X2: A] : ( member @ A @ X2 @ ( top_top @ ( set @ A ) ) ) ).

% iso_tuple_UNIV_I
thf(fact_83_quot__type_OQuotient,axiom,
    ! [A: $tType,B: $tType,R: A > A > $o,Abs: ( set @ A ) > B,Rep: B > ( set @ A )] :
      ( ( quot_type @ A @ B @ R @ Abs @ Rep )
     => ( quotient3 @ A @ B @ R @ ( quot_abs @ A @ B @ R @ Abs ) @ ( quot_rep @ B @ A @ Rep ) ) ) ).

% quot_type.Quotient
thf(fact_84_in__inv__imagep,axiom,
    ! [B: $tType,A: $tType] :
      ( ( inv_imagep @ A @ B )
      = ( ^ [R3: A > A > $o,F: B > A,X4: B,Y: B] : ( R3 @ ( F @ X4 ) @ ( F @ Y ) ) ) ) ).

% in_inv_imagep
thf(fact_85_is__singletonI,axiom,
    ! [A: $tType,X2: A] : ( is_singleton @ A @ ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% is_singletonI
thf(fact_86_bijection_Oinv__right__eq__iff,axiom,
    ! [A: $tType,F3: A > A,B3: A,A2: A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( ( B3
          = ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) ) @ F3 @ A2 ) )
        = ( ( F3 @ B3 )
          = A2 ) ) ) ).

% bijection.inv_right_eq_iff
thf(fact_87_bijection_Oinv__left__eq__iff,axiom,
    ! [A: $tType,F3: A > A,A2: A,B3: A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( ( ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) ) @ F3 @ A2 )
          = B3 )
        = ( ( F3 @ B3 )
          = A2 ) ) ) ).

% bijection.inv_left_eq_iff
thf(fact_88_bijection_Oeq__inv__iff,axiom,
    ! [A: $tType,F3: A > A,A2: A,B3: A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( ( ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) ) @ F3 @ A2 )
          = ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) ) @ F3 @ B3 ) )
        = ( A2 = B3 ) ) ) ).

% bijection.eq_inv_iff
thf(fact_89_insert__absorb2,axiom,
    ! [A: $tType,X2: A,A3: set @ A] :
      ( ( insert @ A @ X2 @ ( insert @ A @ X2 @ A3 ) )
      = ( insert @ A @ X2 @ A3 ) ) ).

% insert_absorb2
thf(fact_90_insert__iff,axiom,
    ! [A: $tType,A2: A,B3: A,A3: set @ A] :
      ( ( member @ A @ A2 @ ( insert @ A @ B3 @ A3 ) )
      = ( ( A2 = B3 )
        | ( member @ A @ A2 @ A3 ) ) ) ).

% insert_iff
thf(fact_91_insertCI,axiom,
    ! [A: $tType,A2: A,B2: set @ A,B3: A] :
      ( ( ~ ( member @ A @ A2 @ B2 )
       => ( A2 = B3 ) )
     => ( member @ A @ A2 @ ( insert @ A @ B3 @ B2 ) ) ) ).

% insertCI
thf(fact_92_singletonI,axiom,
    ! [A: $tType,A2: A] : ( member @ A @ A2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singletonI
thf(fact_93_singleton__conv,axiom,
    ! [A: $tType,A2: A] :
      ( ( collect @ A
        @ ^ [X4: A] : ( X4 = A2 ) )
      = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singleton_conv
thf(fact_94_singleton__conv2,axiom,
    ! [A: $tType,A2: A] :
      ( ( collect @ A
        @ ( ^ [Y2: A,Z: A] : ( Y2 = Z )
          @ A2 ) )
      = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singleton_conv2
thf(fact_95_Quotient3__rep__reflp,axiom,
    ! [A: $tType,B: $tType,R: A > A > $o,Abs: A > B,Rep: B > A,A2: B] :
      ( ( quotient3 @ A @ B @ R @ Abs @ Rep )
     => ( R @ ( Rep @ A2 ) @ ( Rep @ A2 ) ) ) ).

% Quotient3_rep_reflp
thf(fact_96_Quotient3__rep__abs,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: A > B,Rep: B > A,R2: A] :
      ( ( quotient3 @ A @ B @ R @ Abs @ Rep )
     => ( ( R @ R2 @ R2 )
       => ( R @ ( Rep @ ( Abs @ R2 ) ) @ R2 ) ) ) ).

% Quotient3_rep_abs
thf(fact_97_Quotient3__rel__rep,axiom,
    ! [A: $tType,B: $tType,R: A > A > $o,Abs: A > B,Rep: B > A,A2: B,B3: B] :
      ( ( quotient3 @ A @ B @ R @ Abs @ Rep )
     => ( ( R @ ( Rep @ A2 ) @ ( Rep @ B3 ) )
        = ( A2 = B3 ) ) ) ).

% Quotient3_rel_rep
thf(fact_98_Quotient3__rel__abs,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: A > B,Rep: B > A,R2: A,S3: A] :
      ( ( quotient3 @ A @ B @ R @ Abs @ Rep )
     => ( ( R @ R2 @ S3 )
       => ( ( Abs @ R2 )
          = ( Abs @ S3 ) ) ) ) ).

% Quotient3_rel_abs
thf(fact_99_Quotient3__abs__rep,axiom,
    ! [A: $tType,B: $tType,R: A > A > $o,Abs: A > B,Rep: B > A,A2: B] :
      ( ( quotient3 @ A @ B @ R @ Abs @ Rep )
     => ( ( Abs @ ( Rep @ A2 ) )
        = A2 ) ) ).

% Quotient3_abs_rep
thf(fact_100_rep__abs__rsp__left,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: A > B,Rep: B > A,X1: A,X22: A] :
      ( ( quotient3 @ A @ B @ R @ Abs @ Rep )
     => ( ( R @ X1 @ X22 )
       => ( R @ ( Rep @ ( Abs @ X1 ) ) @ X22 ) ) ) ).

% rep_abs_rsp_left
thf(fact_101_Quotient3__refl2,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: A > B,Rep: B > A,R2: A,S3: A] :
      ( ( quotient3 @ A @ B @ R @ Abs @ Rep )
     => ( ( R @ R2 @ S3 )
       => ( R @ S3 @ S3 ) ) ) ).

% Quotient3_refl2
thf(fact_102_Quotient3__refl1,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: A > B,Rep: B > A,R2: A,S3: A] :
      ( ( quotient3 @ A @ B @ R @ Abs @ Rep )
     => ( ( R @ R2 @ S3 )
       => ( R @ R2 @ R2 ) ) ) ).

% Quotient3_refl1
thf(fact_103_Quotient3__rel,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: A > B,Rep: B > A,R2: A,S3: A] :
      ( ( quotient3 @ A @ B @ R @ Abs @ Rep )
     => ( ( ( R @ R2 @ R2 )
          & ( R @ S3 @ S3 )
          & ( ( Abs @ R2 )
            = ( Abs @ S3 ) ) )
        = ( R @ R2 @ S3 ) ) ) ).

% Quotient3_rel
thf(fact_104_Quotient3__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( quotient3 @ A @ B )
      = ( ^ [R4: A > A > $o,Abs2: A > B,Rep2: B > A] :
            ( ! [A4: B] :
                ( ( Abs2 @ ( Rep2 @ A4 ) )
                = A4 )
            & ! [A4: B] : ( R4 @ ( Rep2 @ A4 ) @ ( Rep2 @ A4 ) )
            & ! [R3: A,S2: A] :
                ( ( R4 @ R3 @ S2 )
                = ( ( R4 @ R3 @ R3 )
                  & ( R4 @ S2 @ S2 )
                  & ( ( Abs2 @ R3 )
                    = ( Abs2 @ S2 ) ) ) ) ) ) ) ).

% Quotient3_def
thf(fact_105_rep__abs__rsp,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: A > B,Rep: B > A,X1: A,X22: A] :
      ( ( quotient3 @ A @ B @ R @ Abs @ Rep )
     => ( ( R @ X1 @ X22 )
       => ( R @ X1 @ ( Rep @ ( Abs @ X22 ) ) ) ) ) ).

% rep_abs_rsp
thf(fact_106_equals__rsp,axiom,
    ! [B: $tType,A: $tType,R: A > A > $o,Abs: A > B,Rep: B > A,Xa: A,Xb: A,Ya: A,Yb: A] :
      ( ( quotient3 @ A @ B @ R @ Abs @ Rep )
     => ( ( R @ Xa @ Xb )
       => ( ( R @ Ya @ Yb )
         => ( ( R @ Xa @ Ya )
            = ( R @ Xb @ Yb ) ) ) ) ) ).

% equals_rsp
thf(fact_107_Quotient3I,axiom,
    ! [B: $tType,A: $tType,Abs: B > A,Rep: A > B,R: B > B > $o] :
      ( ! [A6: A] :
          ( ( Abs @ ( Rep @ A6 ) )
          = A6 )
     => ( ! [A6: A] : ( R @ ( Rep @ A6 ) @ ( Rep @ A6 ) )
       => ( ! [R5: B,S4: B] :
              ( ( R @ R5 @ S4 )
              = ( ( R @ R5 @ R5 )
                & ( R @ S4 @ S4 )
                & ( ( Abs @ R5 )
                  = ( Abs @ S4 ) ) ) )
         => ( quotient3 @ B @ A @ R @ Abs @ Rep ) ) ) ) ).

% Quotient3I
thf(fact_108_cond__prs,axiom,
    ! [A: $tType,B: $tType,R: A > A > $o,Absf: A > B,Repf: B > A,A2: $o,B3: B,C3: B] :
      ( ( quotient3 @ A @ B @ R @ Absf @ Repf )
     => ( ( A2
         => ( ( Absf @ ( if @ A @ A2 @ ( Repf @ B3 ) @ ( Repf @ C3 ) ) )
            = B3 ) )
        & ( ~ A2
         => ( ( Absf @ ( if @ A @ A2 @ ( Repf @ B3 ) @ ( Repf @ C3 ) ) )
            = C3 ) ) ) ) ).

% cond_prs
thf(fact_109_bijection_Oeq__iff,axiom,
    ! [A: $tType,F3: A > A,A2: A,B3: A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( ( ( F3 @ A2 )
          = ( F3 @ B3 ) )
        = ( A2 = B3 ) ) ) ).

% bijection.eq_iff
thf(fact_110_bijection_OeqI,axiom,
    ! [A: $tType,F3: A > A,A2: A,B3: A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( ( ( F3 @ A2 )
          = ( F3 @ B3 ) )
       => ( A2 = B3 ) ) ) ).

% bijection.eqI
thf(fact_111_mk__disjoint__insert,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ A3 )
     => ? [B5: set @ A] :
          ( ( A3
            = ( insert @ A @ A2 @ B5 ) )
          & ~ ( member @ A @ A2 @ B5 ) ) ) ).

% mk_disjoint_insert
thf(fact_112_insert__commute,axiom,
    ! [A: $tType,X2: A,Y4: A,A3: set @ A] :
      ( ( insert @ A @ X2 @ ( insert @ A @ Y4 @ A3 ) )
      = ( insert @ A @ Y4 @ ( insert @ A @ X2 @ A3 ) ) ) ).

% insert_commute
thf(fact_113_insert__Collect,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( insert @ A @ A2 @ ( collect @ A @ P ) )
      = ( collect @ A
        @ ^ [U: A] :
            ( ( U != A2 )
           => ( P @ U ) ) ) ) ).

% insert_Collect
thf(fact_114_insert__eq__iff,axiom,
    ! [A: $tType,A2: A,A3: set @ A,B3: A,B2: set @ A] :
      ( ~ ( member @ A @ A2 @ A3 )
     => ( ~ ( member @ A @ B3 @ B2 )
       => ( ( ( insert @ A @ A2 @ A3 )
            = ( insert @ A @ B3 @ B2 ) )
          = ( ( ( A2 = B3 )
             => ( A3 = B2 ) )
            & ( ( A2 != B3 )
             => ? [C4: set @ A] :
                  ( ( A3
                    = ( insert @ A @ B3 @ C4 ) )
                  & ~ ( member @ A @ B3 @ C4 )
                  & ( B2
                    = ( insert @ A @ A2 @ C4 ) )
                  & ~ ( member @ A @ A2 @ C4 ) ) ) ) ) ) ) ).

% insert_eq_iff
thf(fact_115_insert__absorb,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ A3 )
     => ( ( insert @ A @ A2 @ A3 )
        = A3 ) ) ).

% insert_absorb
thf(fact_116_insert__ident,axiom,
    ! [A: $tType,X2: A,A3: set @ A,B2: set @ A] :
      ( ~ ( member @ A @ X2 @ A3 )
     => ( ~ ( member @ A @ X2 @ B2 )
       => ( ( ( insert @ A @ X2 @ A3 )
            = ( insert @ A @ X2 @ B2 ) )
          = ( A3 = B2 ) ) ) ) ).

% insert_ident
thf(fact_117_insert__compr,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [A4: A,B6: set @ A] :
            ( collect @ A
            @ ^ [X4: A] :
                ( ( X4 = A4 )
                | ( member @ A @ X4 @ B6 ) ) ) ) ) ).

% insert_compr
thf(fact_118_Set_Oset__insert,axiom,
    ! [A: $tType,X2: A,A3: set @ A] :
      ( ( member @ A @ X2 @ A3 )
     => ~ ! [B5: set @ A] :
            ( ( A3
              = ( insert @ A @ X2 @ B5 ) )
           => ( member @ A @ X2 @ B5 ) ) ) ).

% Set.set_insert
thf(fact_119_insertI2,axiom,
    ! [A: $tType,A2: A,B2: set @ A,B3: A] :
      ( ( member @ A @ A2 @ B2 )
     => ( member @ A @ A2 @ ( insert @ A @ B3 @ B2 ) ) ) ).

% insertI2
thf(fact_120_insertI1,axiom,
    ! [A: $tType,A2: A,B2: set @ A] : ( member @ A @ A2 @ ( insert @ A @ A2 @ B2 ) ) ).

% insertI1
thf(fact_121_insertE,axiom,
    ! [A: $tType,A2: A,B3: A,A3: set @ A] :
      ( ( member @ A @ A2 @ ( insert @ A @ B3 @ A3 ) )
     => ( ( A2 != B3 )
       => ( member @ A @ A2 @ A3 ) ) ) ).

% insertE
thf(fact_122_top__empty__eq,axiom,
    ! [A: $tType] :
      ( ( top_top @ ( A > $o ) )
      = ( ^ [X4: A] : ( member @ A @ X4 @ ( top_top @ ( set @ A ) ) ) ) ) ).

% top_empty_eq
thf(fact_123_top__set__def,axiom,
    ! [A: $tType] :
      ( ( top_top @ ( set @ A ) )
      = ( collect @ A @ ( top_top @ ( A > $o ) ) ) ) ).

% top_set_def
thf(fact_124_singleton__inject,axiom,
    ! [A: $tType,A2: A,B3: A] :
      ( ( ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( A2 = B3 ) ) ).

% singleton_inject
thf(fact_125_insert__not__empty,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( insert @ A @ A2 @ A3 )
     != ( bot_bot @ ( set @ A ) ) ) ).

% insert_not_empty
thf(fact_126_doubleton__eq__iff,axiom,
    ! [A: $tType,A2: A,B3: A,C3: A,D2: A] :
      ( ( ( insert @ A @ A2 @ ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
        = ( insert @ A @ C3 @ ( insert @ A @ D2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( ( ( A2 = C3 )
          & ( B3 = D2 ) )
        | ( ( A2 = D2 )
          & ( B3 = C3 ) ) ) ) ).

% doubleton_eq_iff
thf(fact_127_singleton__iff,axiom,
    ! [A: $tType,B3: A,A2: A] :
      ( ( member @ A @ B3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( B3 = A2 ) ) ).

% singleton_iff
thf(fact_128_singletonD,axiom,
    ! [A: $tType,B3: A,A2: A] :
      ( ( member @ A @ B3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( B3 = A2 ) ) ).

% singletonD
thf(fact_129_insert__UNIV,axiom,
    ! [A: $tType,X2: A] :
      ( ( insert @ A @ X2 @ ( top_top @ ( set @ A ) ) )
      = ( top_top @ ( set @ A ) ) ) ).

% insert_UNIV
thf(fact_130_Collect__conv__if,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X4: A] :
                ( ( X4 = A2 )
                & ( P @ X4 ) ) )
          = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      & ( ~ ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X4: A] :
                ( ( X4 = A2 )
                & ( P @ X4 ) ) )
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Collect_conv_if
thf(fact_131_Collect__conv__if2,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X4: A] :
                ( ( A2 = X4 )
                & ( P @ X4 ) ) )
          = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      & ( ~ ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X4: A] :
                ( ( A2 = X4 )
                & ( P @ X4 ) ) )
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Collect_conv_if2
thf(fact_132_inv__imagep__def,axiom,
    ! [A: $tType,B: $tType] :
      ( ( inv_imagep @ B @ A )
      = ( ^ [R3: B > B > $o,F: A > B,X4: A,Y: A] : ( R3 @ ( F @ X4 ) @ ( F @ Y ) ) ) ) ).

% inv_imagep_def
thf(fact_133_is__singleton__def,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A5: set @ A] :
          ? [X4: A] :
            ( A5
            = ( insert @ A @ X4 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_def
thf(fact_134_is__singletonE,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( is_singleton @ A @ A3 )
     => ~ ! [X: A] :
            ( A3
           != ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% is_singletonE
thf(fact_135_bijection_Oeq__invI,axiom,
    ! [A: $tType,F3: A > A,A2: A,B3: A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( ( ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) ) @ F3 @ A2 )
          = ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) ) @ F3 @ B3 ) )
       => ( A2 = B3 ) ) ) ).

% bijection.eq_invI
thf(fact_136_bijection_Oinv__left,axiom,
    ! [A: $tType,F3: A > A,A2: A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) ) @ F3 @ ( F3 @ A2 ) )
        = A2 ) ) ).

% bijection.inv_left
thf(fact_137_bijection_Oinv__right,axiom,
    ! [A: $tType,F3: A > A,A2: A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( ( F3 @ ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) ) @ F3 @ A2 ) )
        = A2 ) ) ).

% bijection.inv_right
thf(fact_138_is__singleton__the__elem,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A5: set @ A] :
            ( A5
            = ( insert @ A @ ( the_elem @ A @ A5 ) @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_the_elem
thf(fact_139_the__elem__eq,axiom,
    ! [A: $tType,X2: A] :
      ( ( the_elem @ A @ ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) )
      = X2 ) ).

% the_elem_eq
thf(fact_140_range__constant,axiom,
    ! [B: $tType,A: $tType,X2: A] :
      ( ( image @ B @ A
        @ ^ [Uu: B] : X2
        @ ( top_top @ ( set @ B ) ) )
      = ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% range_constant
thf(fact_141_bijection_Osurj__inv,axiom,
    ! [A: $tType,F3: A > A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( ( image @ A @ A @ ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) ) @ F3 ) @ ( top_top @ ( set @ A ) ) )
        = ( top_top @ ( set @ A ) ) ) ) ).

% bijection.surj_inv
thf(fact_142_bijection_Oinj__inv,axiom,
    ! [A: $tType,F3: A > A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( inj_on @ A @ A @ ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) ) @ F3 ) @ ( top_top @ ( set @ A ) ) ) ) ).

% bijection.inj_inv
thf(fact_143_bijection_Obij__inv,axiom,
    ! [A: $tType,F3: A > A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( bij_betw @ A @ A @ ( hilbert_inv_into @ A @ A @ ( top_top @ ( set @ A ) ) @ F3 ) @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ A ) ) ) ) ).

% bijection.bij_inv
thf(fact_144_image__eqI,axiom,
    ! [A: $tType,B: $tType,B3: A,F3: B > A,X2: B,A3: set @ B] :
      ( ( B3
        = ( F3 @ X2 ) )
     => ( ( member @ B @ X2 @ A3 )
       => ( member @ A @ B3 @ ( image @ B @ A @ F3 @ A3 ) ) ) ) ).

% image_eqI
thf(fact_145_image__ident,axiom,
    ! [A: $tType,Y6: set @ A] :
      ( ( image @ A @ A
        @ ^ [X4: A] : X4
        @ Y6 )
      = Y6 ) ).

% image_ident
thf(fact_146_top1I,axiom,
    ! [A: $tType,X2: A] : ( top_top @ ( A > $o ) @ X2 ) ).

% top1I
thf(fact_147_image__is__empty,axiom,
    ! [A: $tType,B: $tType,F3: B > A,A3: set @ B] :
      ( ( ( image @ B @ A @ F3 @ A3 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( A3
        = ( bot_bot @ ( set @ B ) ) ) ) ).

% image_is_empty
thf(fact_148_empty__is__image,axiom,
    ! [A: $tType,B: $tType,F3: B > A,A3: set @ B] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( image @ B @ A @ F3 @ A3 ) )
      = ( A3
        = ( bot_bot @ ( set @ B ) ) ) ) ).

% empty_is_image
thf(fact_149_image__empty,axiom,
    ! [B: $tType,A: $tType,F3: B > A] :
      ( ( image @ B @ A @ F3 @ ( bot_bot @ ( set @ B ) ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% image_empty
thf(fact_150_image__insert,axiom,
    ! [A: $tType,B: $tType,F3: B > A,A2: B,B2: set @ B] :
      ( ( image @ B @ A @ F3 @ ( insert @ B @ A2 @ B2 ) )
      = ( insert @ A @ ( F3 @ A2 ) @ ( image @ B @ A @ F3 @ B2 ) ) ) ).

% image_insert
thf(fact_151_insert__image,axiom,
    ! [B: $tType,A: $tType,X2: A,A3: set @ A,F3: A > B] :
      ( ( member @ A @ X2 @ A3 )
     => ( ( insert @ B @ ( F3 @ X2 ) @ ( image @ A @ B @ F3 @ A3 ) )
        = ( image @ A @ B @ F3 @ A3 ) ) ) ).

% insert_image
thf(fact_152_inv__into__f__f,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A3: set @ A,X2: A] :
      ( ( inj_on @ A @ B @ F3 @ A3 )
     => ( ( member @ A @ X2 @ A3 )
       => ( ( hilbert_inv_into @ A @ B @ A3 @ F3 @ ( F3 @ X2 ) )
          = X2 ) ) ) ).

% inv_into_f_f
thf(fact_153_inj__imp__bij__betw__inv,axiom,
    ! [B: $tType,A: $tType,F3: A > B,M: set @ A] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( bij_betw @ B @ A @ ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ F3 ) @ ( image @ A @ B @ F3 @ M ) @ M ) ) ).

% inj_imp_bij_betw_inv
thf(fact_154_inj__transfer,axiom,
    ! [B: $tType,A: $tType,F3: A > B,P: A > $o,X2: A] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ! [Y3: B] :
            ( ( member @ B @ Y3 @ ( image @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) ) )
           => ( P @ ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ F3 @ Y3 ) ) )
       => ( P @ X2 ) ) ) ).

% inj_transfer
thf(fact_155_image__inv__f__f,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A3: set @ A] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ( image @ B @ A @ ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ F3 ) @ ( image @ A @ B @ F3 @ A3 ) )
        = A3 ) ) ).

% image_inv_f_f
thf(fact_156_inj__imp__surj__inv,axiom,
    ! [B: $tType,A: $tType,F3: A > B] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ( image @ B @ A @ ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ F3 ) @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) ) ) ).

% inj_imp_surj_inv
thf(fact_157_surj__imp__inj__inv,axiom,
    ! [B: $tType,A: $tType,F3: B > A] :
      ( ( ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ( inj_on @ A @ B @ ( hilbert_inv_into @ B @ A @ ( top_top @ ( set @ B ) ) @ F3 ) @ ( top_top @ ( set @ A ) ) ) ) ).

% surj_imp_inj_inv
thf(fact_158_bijI_H,axiom,
    ! [A: $tType,B: $tType,F3: A > B] :
      ( ! [X: A,Y3: A] :
          ( ( ( F3 @ X )
            = ( F3 @ Y3 ) )
          = ( X = Y3 ) )
     => ( ! [Y3: B] :
          ? [X5: A] :
            ( Y3
            = ( F3 @ X5 ) )
       => ( bij_betw @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ B ) ) ) ) ) ).

% bijI'
thf(fact_159_imageE,axiom,
    ! [A: $tType,B: $tType,B3: A,F3: B > A,A3: set @ B] :
      ( ( member @ A @ B3 @ ( image @ B @ A @ F3 @ A3 ) )
     => ~ ! [X: B] :
            ( ( B3
              = ( F3 @ X ) )
           => ~ ( member @ B @ X @ A3 ) ) ) ).

% imageE
thf(fact_160_imageI,axiom,
    ! [B: $tType,A: $tType,X2: A,A3: set @ A,F3: A > B] :
      ( ( member @ A @ X2 @ A3 )
     => ( member @ B @ ( F3 @ X2 ) @ ( image @ A @ B @ F3 @ A3 ) ) ) ).

% imageI
thf(fact_161_image__iff,axiom,
    ! [A: $tType,B: $tType,Z2: A,F3: B > A,A3: set @ B] :
      ( ( member @ A @ Z2 @ ( image @ B @ A @ F3 @ A3 ) )
      = ( ? [X4: B] :
            ( ( member @ B @ X4 @ A3 )
            & ( Z2
              = ( F3 @ X4 ) ) ) ) ) ).

% image_iff
thf(fact_162_bex__imageD,axiom,
    ! [A: $tType,B: $tType,F3: B > A,A3: set @ B,P: A > $o] :
      ( ? [X5: A] :
          ( ( member @ A @ X5 @ ( image @ B @ A @ F3 @ A3 ) )
          & ( P @ X5 ) )
     => ? [X: B] :
          ( ( member @ B @ X @ A3 )
          & ( P @ ( F3 @ X ) ) ) ) ).

% bex_imageD
thf(fact_163_image__cong,axiom,
    ! [B: $tType,A: $tType,M: set @ A,N: set @ A,F3: A > B,G: A > B] :
      ( ( M = N )
     => ( ! [X: A] :
            ( ( member @ A @ X @ N )
           => ( ( F3 @ X )
              = ( G @ X ) ) )
       => ( ( image @ A @ B @ F3 @ M )
          = ( image @ A @ B @ G @ N ) ) ) ) ).

% image_cong
thf(fact_164_ball__imageD,axiom,
    ! [A: $tType,B: $tType,F3: B > A,A3: set @ B,P: A > $o] :
      ( ! [X: A] :
          ( ( member @ A @ X @ ( image @ B @ A @ F3 @ A3 ) )
         => ( P @ X ) )
     => ! [X5: B] :
          ( ( member @ B @ X5 @ A3 )
         => ( P @ ( F3 @ X5 ) ) ) ) ).

% ball_imageD
thf(fact_165_image__image,axiom,
    ! [A: $tType,B: $tType,C: $tType,F3: B > A,G: C > B,A3: set @ C] :
      ( ( image @ B @ A @ F3 @ ( image @ C @ B @ G @ A3 ) )
      = ( image @ C @ A
        @ ^ [X4: C] : ( F3 @ ( G @ X4 ) )
        @ A3 ) ) ).

% image_image
thf(fact_166_rev__image__eqI,axiom,
    ! [B: $tType,A: $tType,X2: A,A3: set @ A,B3: B,F3: A > B] :
      ( ( member @ A @ X2 @ A3 )
     => ( ( B3
          = ( F3 @ X2 ) )
       => ( member @ B @ B3 @ ( image @ A @ B @ F3 @ A3 ) ) ) ) ).

% rev_image_eqI
thf(fact_167_Compr__image__eq,axiom,
    ! [A: $tType,B: $tType,F3: B > A,A3: set @ B,P: A > $o] :
      ( ( collect @ A
        @ ^ [X4: A] :
            ( ( member @ A @ X4 @ ( image @ B @ A @ F3 @ A3 ) )
            & ( P @ X4 ) ) )
      = ( image @ B @ A @ F3
        @ ( collect @ B
          @ ^ [X4: B] :
              ( ( member @ B @ X4 @ A3 )
              & ( P @ ( F3 @ X4 ) ) ) ) ) ) ).

% Compr_image_eq
thf(fact_168_the__elem__image__unique,axiom,
    ! [B: $tType,A: $tType,A3: set @ A,F3: A > B,X2: A] :
      ( ( A3
       != ( bot_bot @ ( set @ A ) ) )
     => ( ! [Y3: A] :
            ( ( member @ A @ Y3 @ A3 )
           => ( ( F3 @ Y3 )
              = ( F3 @ X2 ) ) )
       => ( ( the_elem @ B @ ( image @ A @ B @ F3 @ A3 ) )
          = ( F3 @ X2 ) ) ) ) ).

% the_elem_image_unique
thf(fact_169_rangeI,axiom,
    ! [A: $tType,B: $tType,F3: B > A,X2: B] : ( member @ A @ ( F3 @ X2 ) @ ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) ) ) ).

% rangeI
thf(fact_170_range__eqI,axiom,
    ! [A: $tType,B: $tType,B3: A,F3: B > A,X2: B] :
      ( ( B3
        = ( F3 @ X2 ) )
     => ( member @ A @ B3 @ ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) ) ) ) ).

% range_eqI
thf(fact_171_bij__image__Collect__eq,axiom,
    ! [A: $tType,B: $tType,F3: A > B,P: A > $o] :
      ( ( bij_betw @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ B ) ) )
     => ( ( image @ A @ B @ F3 @ ( collect @ A @ P ) )
        = ( collect @ B
          @ ^ [Y: B] : ( P @ ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ F3 @ Y ) ) ) ) ) ).

% bij_image_Collect_eq
thf(fact_172_bij__betw__inv__into,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A3: set @ A,B2: set @ B] :
      ( ( bij_betw @ A @ B @ F3 @ A3 @ B2 )
     => ( bij_betw @ B @ A @ ( hilbert_inv_into @ A @ B @ A3 @ F3 ) @ B2 @ A3 ) ) ).

% bij_betw_inv_into
thf(fact_173_inv__into__inv__into__eq,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A3: set @ A,A7: set @ B,A2: A] :
      ( ( bij_betw @ A @ B @ F3 @ A3 @ A7 )
     => ( ( member @ A @ A2 @ A3 )
       => ( ( hilbert_inv_into @ B @ A @ A7 @ ( hilbert_inv_into @ A @ B @ A3 @ F3 ) @ A2 )
          = ( F3 @ A2 ) ) ) ) ).

% inv_into_inv_into_eq
thf(fact_174_bij__betw__inv__into__left,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A3: set @ A,A7: set @ B,A2: A] :
      ( ( bij_betw @ A @ B @ F3 @ A3 @ A7 )
     => ( ( member @ A @ A2 @ A3 )
       => ( ( hilbert_inv_into @ A @ B @ A3 @ F3 @ ( F3 @ A2 ) )
          = A2 ) ) ) ).

% bij_betw_inv_into_left
thf(fact_175_bij__betw__inv__into__right,axiom,
    ! [A: $tType,B: $tType,F3: A > B,A3: set @ A,A7: set @ B,A8: B] :
      ( ( bij_betw @ A @ B @ F3 @ A3 @ A7 )
     => ( ( member @ B @ A8 @ A7 )
       => ( ( F3 @ ( hilbert_inv_into @ A @ B @ A3 @ F3 @ A8 ) )
          = A8 ) ) ) ).

% bij_betw_inv_into_right
thf(fact_176_inv__into__f__eq,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A3: set @ A,X2: A,Y4: B] :
      ( ( inj_on @ A @ B @ F3 @ A3 )
     => ( ( member @ A @ X2 @ A3 )
       => ( ( ( F3 @ X2 )
            = Y4 )
         => ( ( hilbert_inv_into @ A @ B @ A3 @ F3 @ Y4 )
            = X2 ) ) ) ) ).

% inv_into_f_eq
thf(fact_177_f__inv__into__f,axiom,
    ! [B: $tType,A: $tType,Y4: A,F3: B > A,A3: set @ B] :
      ( ( member @ A @ Y4 @ ( image @ B @ A @ F3 @ A3 ) )
     => ( ( F3 @ ( hilbert_inv_into @ B @ A @ A3 @ F3 @ Y4 ) )
        = Y4 ) ) ).

% f_inv_into_f
thf(fact_178_inv__into__into,axiom,
    ! [A: $tType,B: $tType,X2: A,F3: B > A,A3: set @ B] :
      ( ( member @ A @ X2 @ ( image @ B @ A @ F3 @ A3 ) )
     => ( member @ B @ ( hilbert_inv_into @ B @ A @ A3 @ F3 @ X2 ) @ A3 ) ) ).

% inv_into_into
thf(fact_179_inv__into__injective,axiom,
    ! [A: $tType,B: $tType,A3: set @ A,F3: A > B,X2: B,Y4: B] :
      ( ( ( hilbert_inv_into @ A @ B @ A3 @ F3 @ X2 )
        = ( hilbert_inv_into @ A @ B @ A3 @ F3 @ Y4 ) )
     => ( ( member @ B @ X2 @ ( image @ A @ B @ F3 @ A3 ) )
       => ( ( member @ B @ Y4 @ ( image @ A @ B @ F3 @ A3 ) )
         => ( X2 = Y4 ) ) ) ) ).

% inv_into_injective
thf(fact_180_setcompr__eq__image,axiom,
    ! [A: $tType,B: $tType,F3: B > A,P: B > $o] :
      ( ( collect @ A
        @ ^ [Uu: A] :
          ? [X4: B] :
            ( ( Uu
              = ( F3 @ X4 ) )
            & ( P @ X4 ) ) )
      = ( image @ B @ A @ F3 @ ( collect @ B @ P ) ) ) ).

% setcompr_eq_image
thf(fact_181_Setcompr__eq__image,axiom,
    ! [A: $tType,B: $tType,F3: B > A,A3: set @ B] :
      ( ( collect @ A
        @ ^ [Uu: A] :
          ? [X4: B] :
            ( ( Uu
              = ( F3 @ X4 ) )
            & ( member @ B @ X4 @ A3 ) ) )
      = ( image @ B @ A @ F3 @ A3 ) ) ).

% Setcompr_eq_image
thf(fact_182_rangeE,axiom,
    ! [A: $tType,B: $tType,B3: A,F3: B > A] :
      ( ( member @ A @ B3 @ ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) ) )
     => ~ ! [X: B] :
            ( B3
           != ( F3 @ X ) ) ) ).

% rangeE
thf(fact_183_range__composition,axiom,
    ! [A: $tType,C: $tType,B: $tType,F3: C > A,G: B > C] :
      ( ( image @ B @ A
        @ ^ [X4: B] : ( F3 @ ( G @ X4 ) )
        @ ( top_top @ ( set @ B ) ) )
      = ( image @ C @ A @ F3 @ ( image @ B @ C @ G @ ( top_top @ ( set @ B ) ) ) ) ) ).

% range_composition
thf(fact_184_bij__imp__bij__inv,axiom,
    ! [B: $tType,A: $tType,F3: A > B] :
      ( ( bij_betw @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ B ) ) )
     => ( bij_betw @ B @ A @ ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ F3 ) @ ( top_top @ ( set @ B ) ) @ ( top_top @ ( set @ A ) ) ) ) ).

% bij_imp_bij_inv
thf(fact_185_bij__inv__eq__iff,axiom,
    ! [A: $tType,B: $tType,P6: A > B,X2: A,Y4: B] :
      ( ( bij_betw @ A @ B @ P6 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ B ) ) )
     => ( ( X2
          = ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ P6 @ Y4 ) )
        = ( ( P6 @ X2 )
          = Y4 ) ) ) ).

% bij_inv_eq_iff
thf(fact_186_inv__inv__eq,axiom,
    ! [B: $tType,A: $tType,F3: A > B] :
      ( ( bij_betw @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ B ) ) )
     => ( ( hilbert_inv_into @ B @ A @ ( top_top @ ( set @ B ) ) @ ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ F3 ) )
        = F3 ) ) ).

% inv_inv_eq
thf(fact_187_inj__imp__inv__eq,axiom,
    ! [A: $tType,B: $tType,F3: A > B,G: B > A] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ! [X: B] :
            ( ( F3 @ ( G @ X ) )
            = X )
       => ( ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ F3 )
          = G ) ) ) ).

% inj_imp_inv_eq
thf(fact_188_inv__f__eq,axiom,
    ! [B: $tType,A: $tType,F3: A > B,X2: A,Y4: B] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ( ( F3 @ X2 )
          = Y4 )
       => ( ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ F3 @ Y4 )
          = X2 ) ) ) ).

% inv_f_eq
thf(fact_189_inv__f__f,axiom,
    ! [B: $tType,A: $tType,F3: A > B,X2: A] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ( hilbert_inv_into @ A @ B @ ( top_top @ ( set @ A ) ) @ F3 @ ( F3 @ X2 ) )
        = X2 ) ) ).

% inv_f_f
thf(fact_190_bijection_Ointro,axiom,
    ! [A: $tType,F3: A > A] :
      ( ( bij_betw @ A @ A @ F3 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ A ) ) )
     => ( hilbert_bijection @ A @ F3 ) ) ).

% bijection.intro
thf(fact_191_bijection__def,axiom,
    ! [A: $tType] :
      ( ( hilbert_bijection @ A )
      = ( ^ [F: A > A] : ( bij_betw @ A @ A @ F @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ A ) ) ) ) ) ).

% bijection_def
thf(fact_192_bijection_Obij,axiom,
    ! [A: $tType,F3: A > A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( bij_betw @ A @ A @ F3 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ A ) ) ) ) ).

% bijection.bij
thf(fact_193_surj__imp__inv__eq,axiom,
    ! [B: $tType,A: $tType,F3: B > A,G: A > B] :
      ( ( ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ( ! [X: B] :
            ( ( G @ ( F3 @ X ) )
            = X )
       => ( ( hilbert_inv_into @ B @ A @ ( top_top @ ( set @ B ) ) @ F3 )
          = G ) ) ) ).

% surj_imp_inv_eq
thf(fact_194_image__f__inv__f,axiom,
    ! [B: $tType,A: $tType,F3: B > A,A3: set @ A] :
      ( ( ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ( ( image @ B @ A @ F3 @ ( image @ A @ B @ ( hilbert_inv_into @ B @ A @ ( top_top @ ( set @ B ) ) @ F3 ) @ A3 ) )
        = A3 ) ) ).

% image_f_inv_f
thf(fact_195_surj__iff__all,axiom,
    ! [B: $tType,A: $tType,F3: B > A] :
      ( ( ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
      = ( ! [X4: A] :
            ( ( F3 @ ( hilbert_inv_into @ B @ A @ ( top_top @ ( set @ B ) ) @ F3 @ X4 ) )
            = X4 ) ) ) ).

% surj_iff_all
thf(fact_196_surj__f__inv__f,axiom,
    ! [B: $tType,A: $tType,F3: B > A,Y4: A] :
      ( ( ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ( ( F3 @ ( hilbert_inv_into @ B @ A @ ( top_top @ ( set @ B ) ) @ F3 @ Y4 ) )
        = Y4 ) ) ).

% surj_f_inv_f
thf(fact_197_bijection_Oinj,axiom,
    ! [A: $tType,F3: A > A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( inj_on @ A @ A @ F3 @ ( top_top @ ( set @ A ) ) ) ) ).

% bijection.inj
thf(fact_198_bijection_Osurj,axiom,
    ! [A: $tType,F3: A > A] :
      ( ( hilbert_bijection @ A @ F3 )
     => ( ( image @ A @ A @ F3 @ ( top_top @ ( set @ A ) ) )
        = ( top_top @ ( set @ A ) ) ) ) ).

% bijection.surj
thf(fact_199_image__constant,axiom,
    ! [A: $tType,B: $tType,X2: A,A3: set @ A,C3: B] :
      ( ( member @ A @ X2 @ A3 )
     => ( ( image @ A @ B
          @ ^ [X4: A] : C3
          @ A3 )
        = ( insert @ B @ C3 @ ( bot_bot @ ( set @ B ) ) ) ) ) ).

% image_constant
thf(fact_200_image__constant__conv,axiom,
    ! [B: $tType,A: $tType,A3: set @ B,C3: A] :
      ( ( ( A3
          = ( bot_bot @ ( set @ B ) ) )
       => ( ( image @ B @ A
            @ ^ [X4: B] : C3
            @ A3 )
          = ( bot_bot @ ( set @ A ) ) ) )
      & ( ( A3
         != ( bot_bot @ ( set @ B ) ) )
       => ( ( image @ B @ A
            @ ^ [X4: B] : C3
            @ A3 )
          = ( insert @ A @ C3 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% image_constant_conv
thf(fact_201_full__SetCompr__eq,axiom,
    ! [A: $tType,B: $tType,F3: B > A] :
      ( ( collect @ A
        @ ^ [U: A] :
          ? [X4: B] :
            ( U
            = ( F3 @ X4 ) ) )
      = ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) ) ) ).

% full_SetCompr_eq
thf(fact_202_range__eq__singletonD,axiom,
    ! [B: $tType,A: $tType,F3: B > A,A2: A,X2: B] :
      ( ( ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) )
        = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( ( F3 @ X2 )
        = A2 ) ) ).

% range_eq_singletonD
thf(fact_203_inj__on__empty,axiom,
    ! [B: $tType,A: $tType,F3: A > B] : ( inj_on @ A @ B @ F3 @ ( bot_bot @ ( set @ A ) ) ) ).

% inj_on_empty
thf(fact_204_bij__def,axiom,
    ! [A: $tType,B: $tType,F3: A > B] :
      ( ( bij_betw @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ B ) ) )
      = ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
        & ( ( image @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
          = ( top_top @ ( set @ B ) ) ) ) ) ).

% bij_def
thf(fact_205_bijI,axiom,
    ! [A: $tType,B: $tType,F3: A > B] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ( ( image @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
          = ( top_top @ ( set @ B ) ) )
       => ( bij_betw @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ B ) ) ) ) ) ).

% bijI
thf(fact_206_bij__is__inj,axiom,
    ! [B: $tType,A: $tType,F3: A > B] :
      ( ( bij_betw @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ B ) ) )
     => ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) ) ) ).

% bij_is_inj
thf(fact_207_inj__on__id2,axiom,
    ! [A: $tType,A3: set @ A] :
      ( inj_on @ A @ A
      @ ^ [X4: A] : X4
      @ A3 ) ).

% inj_on_id2
thf(fact_208_surjD,axiom,
    ! [A: $tType,B: $tType,F3: B > A,Y4: A] :
      ( ( ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ? [X: B] :
          ( Y4
          = ( F3 @ X ) ) ) ).

% surjD
thf(fact_209_surjE,axiom,
    ! [A: $tType,B: $tType,F3: B > A,Y4: A] :
      ( ( ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ~ ! [X: B] :
            ( Y4
           != ( F3 @ X ) ) ) ).

% surjE
thf(fact_210_surjI,axiom,
    ! [B: $tType,A: $tType,G: B > A,F3: A > B] :
      ( ! [X: A] :
          ( ( G @ ( F3 @ X ) )
          = X )
     => ( ( image @ B @ A @ G @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) ) ) ).

% surjI
thf(fact_211_surj__def,axiom,
    ! [B: $tType,A: $tType,F3: B > A] :
      ( ( ( image @ B @ A @ F3 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
      = ( ! [Y: A] :
          ? [X4: B] :
            ( Y
            = ( F3 @ X4 ) ) ) ) ).

% surj_def
thf(fact_212_injD,axiom,
    ! [B: $tType,A: $tType,F3: A > B,X2: A,Y4: A] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ( ( F3 @ X2 )
          = ( F3 @ Y4 ) )
       => ( X2 = Y4 ) ) ) ).

% injD
thf(fact_213_injI,axiom,
    ! [B: $tType,A: $tType,F3: A > B] :
      ( ! [X: A,Y3: A] :
          ( ( ( F3 @ X )
            = ( F3 @ Y3 ) )
         => ( X = Y3 ) )
     => ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) ) ) ).

% injI
thf(fact_214_inj__eq,axiom,
    ! [B: $tType,A: $tType,F3: A > B,X2: A,Y4: A] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ( ( F3 @ X2 )
          = ( F3 @ Y4 ) )
        = ( X2 = Y4 ) ) ) ).

% inj_eq
thf(fact_215_inj__def,axiom,
    ! [B: $tType,A: $tType,F3: A > B] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
      = ( ! [X4: A,Y: A] :
            ( ( ( F3 @ X4 )
              = ( F3 @ Y ) )
           => ( X4 = Y ) ) ) ) ).

% inj_def
thf(fact_216_bij__betw__empty2,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A3: set @ A] :
      ( ( bij_betw @ A @ B @ F3 @ A3 @ ( bot_bot @ ( set @ B ) ) )
     => ( A3
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% bij_betw_empty2
thf(fact_217_bij__betw__empty1,axiom,
    ! [A: $tType,B: $tType,F3: A > B,A3: set @ B] :
      ( ( bij_betw @ A @ B @ F3 @ ( bot_bot @ ( set @ A ) ) @ A3 )
     => ( A3
        = ( bot_bot @ ( set @ B ) ) ) ) ).

% bij_betw_empty1
thf(fact_218_bij__pointE,axiom,
    ! [B: $tType,A: $tType,F3: A > B,Y4: B] :
      ( ( bij_betw @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ B ) ) )
     => ~ ! [X: A] :
            ( ( Y4
              = ( F3 @ X ) )
           => ~ ! [X8: A] :
                  ( ( Y4
                    = ( F3 @ X8 ) )
                 => ( X8 = X ) ) ) ) ).

% bij_pointE
thf(fact_219_inj__singleton,axiom,
    ! [A: $tType,A3: set @ A] :
      ( inj_on @ A @ ( set @ A )
      @ ^ [X4: A] : ( insert @ A @ X4 @ ( bot_bot @ ( set @ A ) ) )
      @ A3 ) ).

% inj_singleton
thf(fact_220_inj__fun,axiom,
    ! [B: $tType,C: $tType,A: $tType,F3: A > B] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( inj_on @ A @ ( C > B )
        @ ^ [X4: A,Y: C] : ( F3 @ X4 )
        @ ( top_top @ ( set @ A ) ) ) ) ).

% inj_fun
thf(fact_221_inj__img__insertE,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A3: set @ A,X2: B,B2: set @ B] :
      ( ( inj_on @ A @ B @ F3 @ A3 )
     => ( ~ ( member @ B @ X2 @ B2 )
       => ( ( ( insert @ B @ X2 @ B2 )
            = ( image @ A @ B @ F3 @ A3 ) )
         => ~ ! [X9: A,A9: set @ A] :
                ( ~ ( member @ A @ X9 @ A9 )
               => ( ( A3
                    = ( insert @ A @ X9 @ A9 ) )
                 => ( ( X2
                      = ( F3 @ X9 ) )
                   => ( B2
                     != ( image @ A @ B @ F3 @ A9 ) ) ) ) ) ) ) ) ).

% inj_img_insertE
thf(fact_222_range__ex1__eq,axiom,
    ! [B: $tType,A: $tType,F3: A > B,B3: B] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ( member @ B @ B3 @ ( image @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) ) )
        = ( ? [X4: A] :
              ( ( B3
                = ( F3 @ X4 ) )
              & ! [Y: A] :
                  ( ( B3
                    = ( F3 @ Y ) )
                 => ( Y = X4 ) ) ) ) ) ) ).

% range_ex1_eq
thf(fact_223_inj__image__eq__iff,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A3: set @ A,B2: set @ A] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ( ( image @ A @ B @ F3 @ A3 )
          = ( image @ A @ B @ F3 @ B2 ) )
        = ( A3 = B2 ) ) ) ).

% inj_image_eq_iff
thf(fact_224_inj__image__mem__iff,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A2: A,A3: set @ A] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ( member @ B @ ( F3 @ A2 ) @ ( image @ A @ B @ F3 @ A3 ) )
        = ( member @ A @ A2 @ A3 ) ) ) ).

% inj_image_mem_iff
thf(fact_225_bij__is__surj,axiom,
    ! [A: $tType,B: $tType,F3: A > B] :
      ( ( bij_betw @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ B ) ) )
     => ( ( image @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
        = ( top_top @ ( set @ B ) ) ) ) ).

% bij_is_surj
thf(fact_226_bij__betw__imp__surj,axiom,
    ! [A: $tType,B: $tType,F3: A > B,A3: set @ A] :
      ( ( bij_betw @ A @ B @ F3 @ A3 @ ( top_top @ ( set @ B ) ) )
     => ( ( image @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
        = ( top_top @ ( set @ B ) ) ) ) ).

% bij_betw_imp_surj
thf(fact_227_inj__on__insert,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A2: A,A3: set @ A] :
      ( ( inj_on @ A @ B @ F3 @ ( insert @ A @ A2 @ A3 ) )
      = ( ( inj_on @ A @ B @ F3 @ A3 )
        & ~ ( member @ B @ ( F3 @ A2 ) @ ( image @ A @ B @ F3 @ ( minus_minus @ ( set @ A ) @ A3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ) ).

% inj_on_insert
thf(fact_228_top__conj_I2_J,axiom,
    ! [A: $tType,P: $o,X2: A] :
      ( ( P
        & ( top_top @ ( A > $o ) @ X2 ) )
      = P ) ).

% top_conj(2)
thf(fact_229_DiffI,axiom,
    ! [A: $tType,C3: A,A3: set @ A,B2: set @ A] :
      ( ( member @ A @ C3 @ A3 )
     => ( ~ ( member @ A @ C3 @ B2 )
       => ( member @ A @ C3 @ ( minus_minus @ ( set @ A ) @ A3 @ B2 ) ) ) ) ).

% DiffI
thf(fact_230_Diff__iff,axiom,
    ! [A: $tType,C3: A,A3: set @ A,B2: set @ A] :
      ( ( member @ A @ C3 @ ( minus_minus @ ( set @ A ) @ A3 @ B2 ) )
      = ( ( member @ A @ C3 @ A3 )
        & ~ ( member @ A @ C3 @ B2 ) ) ) ).

% Diff_iff
thf(fact_231_Diff__idemp,axiom,
    ! [A: $tType,A3: set @ A,B2: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A3 @ B2 ) @ B2 )
      = ( minus_minus @ ( set @ A ) @ A3 @ B2 ) ) ).

% Diff_idemp
thf(fact_232_Diff__empty,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A3 @ ( bot_bot @ ( set @ A ) ) )
      = A3 ) ).

% Diff_empty
thf(fact_233_empty__Diff,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ A3 )
      = ( bot_bot @ ( set @ A ) ) ) ).

% empty_Diff
thf(fact_234_Diff__cancel,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A3 @ A3 )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Diff_cancel
thf(fact_235_insert__Diff1,axiom,
    ! [A: $tType,X2: A,B2: set @ A,A3: set @ A] :
      ( ( member @ A @ X2 @ B2 )
     => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X2 @ A3 ) @ B2 )
        = ( minus_minus @ ( set @ A ) @ A3 @ B2 ) ) ) ).

% insert_Diff1
thf(fact_236_Diff__insert0,axiom,
    ! [A: $tType,X2: A,A3: set @ A,B2: set @ A] :
      ( ~ ( member @ A @ X2 @ A3 )
     => ( ( minus_minus @ ( set @ A ) @ A3 @ ( insert @ A @ X2 @ B2 ) )
        = ( minus_minus @ ( set @ A ) @ A3 @ B2 ) ) ) ).

% Diff_insert0
thf(fact_237_insert__Diff__single,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( insert @ A @ A2 @ ( minus_minus @ ( set @ A ) @ A3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( insert @ A @ A2 @ A3 ) ) ).

% insert_Diff_single
thf(fact_238_Diff__UNIV,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A3 @ ( top_top @ ( set @ A ) ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Diff_UNIV
thf(fact_239_surj__diff__right,axiom,
    ! [A: $tType] :
      ( ( ab_group_add @ A )
     => ! [A2: A] :
          ( ( image @ A @ A
            @ ^ [X4: A] : ( minus_minus @ A @ X4 @ A2 )
            @ ( top_top @ ( set @ A ) ) )
          = ( top_top @ ( set @ A ) ) ) ) ).

% surj_diff_right
thf(fact_240_inj__diff__right,axiom,
    ! [A: $tType] :
      ( ( ab_group_add @ A )
     => ! [A2: A] :
          ( inj_on @ A @ A
          @ ^ [B4: A] : ( minus_minus @ A @ B4 @ A2 )
          @ ( top_top @ ( set @ A ) ) ) ) ).

% inj_diff_right
thf(fact_241_translation__subtract__diff,axiom,
    ! [A: $tType] :
      ( ( ab_group_add @ A )
     => ! [A2: A,S3: set @ A,T: set @ A] :
          ( ( image @ A @ A
            @ ^ [X4: A] : ( minus_minus @ A @ X4 @ A2 )
            @ ( minus_minus @ ( set @ A ) @ S3 @ T ) )
          = ( minus_minus @ ( set @ A )
            @ ( image @ A @ A
              @ ^ [X4: A] : ( minus_minus @ A @ X4 @ A2 )
              @ S3 )
            @ ( image @ A @ A
              @ ^ [X4: A] : ( minus_minus @ A @ X4 @ A2 )
              @ T ) ) ) ) ).

% translation_subtract_diff
thf(fact_242_Diff__insert__absorb,axiom,
    ! [A: $tType,X2: A,A3: set @ A] :
      ( ~ ( member @ A @ X2 @ A3 )
     => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X2 @ A3 ) @ ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) )
        = A3 ) ) ).

% Diff_insert_absorb
thf(fact_243_Diff__insert2,axiom,
    ! [A: $tType,A3: set @ A,A2: A,B2: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A3 @ ( insert @ A @ A2 @ B2 ) )
      = ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) @ B2 ) ) ).

% Diff_insert2
thf(fact_244_insert__Diff,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ A3 )
     => ( ( insert @ A @ A2 @ ( minus_minus @ ( set @ A ) @ A3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
        = A3 ) ) ).

% insert_Diff
thf(fact_245_Diff__insert,axiom,
    ! [A: $tType,A3: set @ A,A2: A,B2: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A3 @ ( insert @ A @ A2 @ B2 ) )
      = ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A3 @ B2 ) @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Diff_insert
thf(fact_246_in__image__insert__iff,axiom,
    ! [A: $tType,B2: set @ ( set @ A ),X2: A,A3: set @ A] :
      ( ! [C5: set @ A] :
          ( ( member @ ( set @ A ) @ C5 @ B2 )
         => ~ ( member @ A @ X2 @ C5 ) )
     => ( ( member @ ( set @ A ) @ A3 @ ( image @ ( set @ A ) @ ( set @ A ) @ ( insert @ A @ X2 ) @ B2 ) )
        = ( ( member @ A @ X2 @ A3 )
          & ( member @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A3 @ ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) @ B2 ) ) ) ) ).

% in_image_insert_iff
thf(fact_247_DiffE,axiom,
    ! [A: $tType,C3: A,A3: set @ A,B2: set @ A] :
      ( ( member @ A @ C3 @ ( minus_minus @ ( set @ A ) @ A3 @ B2 ) )
     => ~ ( ( member @ A @ C3 @ A3 )
         => ( member @ A @ C3 @ B2 ) ) ) ).

% DiffE
thf(fact_248_DiffD1,axiom,
    ! [A: $tType,C3: A,A3: set @ A,B2: set @ A] :
      ( ( member @ A @ C3 @ ( minus_minus @ ( set @ A ) @ A3 @ B2 ) )
     => ( member @ A @ C3 @ A3 ) ) ).

% DiffD1
thf(fact_249_DiffD2,axiom,
    ! [A: $tType,C3: A,A3: set @ A,B2: set @ A] :
      ( ( member @ A @ C3 @ ( minus_minus @ ( set @ A ) @ A3 @ B2 ) )
     => ~ ( member @ A @ C3 @ B2 ) ) ).

% DiffD2
thf(fact_250_set__diff__eq,axiom,
    ! [A: $tType] :
      ( ( minus_minus @ ( set @ A ) )
      = ( ^ [A5: set @ A,B6: set @ A] :
            ( collect @ A
            @ ^ [X4: A] :
                ( ( member @ A @ X4 @ A5 )
                & ~ ( member @ A @ X4 @ B6 ) ) ) ) ) ).

% set_diff_eq
thf(fact_251_insert__Diff__if,axiom,
    ! [A: $tType,X2: A,B2: set @ A,A3: set @ A] :
      ( ( ( member @ A @ X2 @ B2 )
       => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X2 @ A3 ) @ B2 )
          = ( minus_minus @ ( set @ A ) @ A3 @ B2 ) ) )
      & ( ~ ( member @ A @ X2 @ B2 )
       => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X2 @ A3 ) @ B2 )
          = ( insert @ A @ X2 @ ( minus_minus @ ( set @ A ) @ A3 @ B2 ) ) ) ) ) ).

% insert_Diff_if
thf(fact_252_image__set__diff,axiom,
    ! [B: $tType,A: $tType,F3: A > B,A3: set @ A,B2: set @ A] :
      ( ( inj_on @ A @ B @ F3 @ ( top_top @ ( set @ A ) ) )
     => ( ( image @ A @ B @ F3 @ ( minus_minus @ ( set @ A ) @ A3 @ B2 ) )
        = ( minus_minus @ ( set @ B ) @ ( image @ A @ B @ F3 @ A3 ) @ ( image @ A @ B @ F3 @ B2 ) ) ) ) ).

% image_set_diff
thf(fact_253_top__conj_I1_J,axiom,
    ! [A: $tType,X2: A,P: $o] :
      ( ( ( top_top @ ( A > $o ) @ X2 )
        & P )
      = P ) ).

% top_conj(1)
thf(fact_254_remove__def,axiom,
    ! [A: $tType] :
      ( ( remove @ A )
      = ( ^ [X4: A,A5: set @ A] : ( minus_minus @ ( set @ A ) @ A5 @ ( insert @ A @ X4 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% remove_def
thf(fact_255_fun__upd__image,axiom,
    ! [A: $tType,B: $tType,X2: B,A3: set @ B,F3: B > A,Y4: A] :
      ( ( ( member @ B @ X2 @ A3 )
       => ( ( image @ B @ A @ ( fun_upd @ B @ A @ F3 @ X2 @ Y4 ) @ A3 )
          = ( insert @ A @ Y4 @ ( image @ B @ A @ F3 @ ( minus_minus @ ( set @ B ) @ A3 @ ( insert @ B @ X2 @ ( bot_bot @ ( set @ B ) ) ) ) ) ) ) )
      & ( ~ ( member @ B @ X2 @ A3 )
       => ( ( image @ B @ A @ ( fun_upd @ B @ A @ F3 @ X2 @ Y4 ) @ A3 )
          = ( image @ B @ A @ F3 @ A3 ) ) ) ) ).

% fun_upd_image

% Type constructors (9)
thf(tcon_fun___Orderings_Otop,axiom,
    ! [A10: $tType,A11: $tType] :
      ( ( top @ A11 )
     => ( top @ ( A10 > A11 ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A10: $tType,A11: $tType] :
      ( ( ord @ A11 )
     => ( ord @ ( A10 > A11 ) ) ) ).

thf(tcon_fun___Orderings_Obot,axiom,
    ! [A10: $tType,A11: $tType] :
      ( ( bot @ A11 )
     => ( bot @ ( A10 > A11 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Otop_1,axiom,
    ! [A10: $tType] : ( top @ ( set @ A10 ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_2,axiom,
    ! [A10: $tType] : ( ord @ ( set @ A10 ) ) ).

thf(tcon_Set_Oset___Orderings_Obot_3,axiom,
    ! [A10: $tType] : ( bot @ ( set @ A10 ) ) ).

thf(tcon_HOL_Obool___Orderings_Otop_4,axiom,
    top @ $o ).

thf(tcon_HOL_Obool___Orderings_Oord_5,axiom,
    ord @ $o ).

thf(tcon_HOL_Obool___Orderings_Obot_6,axiom,
    bot @ $o ).

% Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X2: A,Y4: A] :
      ( ( if @ A @ $false @ X2 @ Y4 )
      = Y4 ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X2: A,Y4: A] :
      ( ( if @ A @ $true @ X2 @ Y4 )
      = X2 ) ).

% Conjectures (2)
thf(conj_0,hypothesis,
    ! [X5: a] :
      ( ( p @ X5 )
     => ? [X_12: b] : ( q @ X5 @ X_12 ) ) ).

thf(conj_1,conjecture,
    ! [X: a] :
      ( ~ ( p @ X )
      | ( q @ X @ ( hilbert_Eps @ b @ ( q @ X ) ) ) ) ).

%------------------------------------------------------------------------------
